% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_nonzero}
\alias{torch_nonzero}
\title{Nonzero}
\usage{
torch_nonzero(self)
}
\arguments{
\item{self}{(Tensor) the input tensor.}
}
\description{
Nonzero
}
\note{
\preformatted{[`torch_nonzero(..., as_tuple=False) <torch.nonzero>`] (default) returns a
2-D tensor where each row is the index for a nonzero value.

[`torch_nonzero(..., as_tuple=TRUE) <torch.nonzero>`] returns a tuple of 1-D
index tensors, allowing for advanced indexing, so `x[x.nonzero(as_tuple=TRUE)]`
gives all nonzero values of tensor `x`. Of the returned tuple, each index tensor
contains nonzero indices for a certain dimension.

See below for more details on the two behaviors.
}
}
\section{nonzero(input, *, out=NULL, as_tuple=False) -> LongTensor or tuple of LongTensors }{


\strong{When} \code{as_tuple} \strong{is \code{FALSE} (default)}:

Returns a tensor containing the indices of all non-zero elements of
\code{input}.  Each row in the result contains the indices of a non-zero
element in \code{input}. The result is sorted lexicographically, with
the last index changing the fastest (C-style).

If \code{input} has \eqn{n} dimensions, then the resulting indices tensor
\code{out} is of size \eqn{(z \times n)}, where \eqn{z} is the total number of
non-zero elements in the \code{input} tensor.

\strong{When} \code{as_tuple} \strong{is \code{TRUE}}:

Returns a tuple of 1-D tensors, one for each dimension in \code{input},
each containing the indices (in that dimension) of all non-zero elements of
\code{input} .

If \code{input} has \eqn{n} dimensions, then the resulting tuple contains \eqn{n}
tensors of size \eqn{z}, where \eqn{z} is the total number of
non-zero elements in the \code{input} tensor.

As a special case, when \code{input} has zero dimensions and a nonzero scalar
value, it is treated as a one-dimensional tensor with one element.
}

\examples{
if (torch_is_installed()) {

torch_nonzero(torch_tensor(c(1, 1, 1, 0, 1)))
}
}
