% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-normalization.R
\name{nn_layer_norm}
\alias{nn_layer_norm}
\title{Layer normalization}
\usage{
nn_layer_norm(normalized_shape, eps = 1e-05, elementwise_affine = TRUE)
}
\arguments{
\item{normalized_shape}{(int or list): input shape from an expected input
of size
\eqn{[* \times \mbox{normalized\_shape}[0] \times \mbox{normalized\_shape}[1] \times \ldots \times \mbox{normalized\_shape}[-1]]}
If a single integer is used, it is treated as a singleton list, and this module will
normalize over the last dimension which is expected to be of that specific size.}

\item{eps}{a value added to the denominator for numerical stability. Default: 1e-5}

\item{elementwise_affine}{a boolean value that when set to \code{TRUE}, this module
has learnable per-element affine parameters initialized to ones (for weights)
and zeros (for biases). Default: \code{TRUE}.}
}
\description{
Applies Layer Normalization over a mini-batch of inputs as described in
the paper \href{https://arxiv.org/abs/1607.06450}{Layer Normalization}
}
\details{
\deqn{
  y = \frac{x - \mathrm{E}[x]}{ \sqrt{\mathrm{Var}[x] + \epsilon}} * \gamma + \beta
}

The mean and standard-deviation are calculated separately over the last
certain number dimensions which have to be of the shape specified by
\code{normalized_shape}.

\eqn{\gamma} and \eqn{\beta} are learnable affine transform parameters of
\code{normalized_shape} if \code{elementwise_affine} is \code{TRUE}.

The standard-deviation is calculated via the biased estimator, equivalent to
\code{torch_var(input, unbiased=FALSE)}.
}
\note{
Unlike Batch Normalization and Instance Normalization, which applies
scalar scale and bias for each entire channel/plane with the
\code{affine} option, Layer Normalization applies per-element scale and
bias with \code{elementwise_affine}.

This layer uses statistics computed from input data in both training and
evaluation modes.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)}
\item Output: \eqn{(N, *)} (same shape as input)
}
}

\examples{
if (torch_is_installed()) {
  
input <- torch_randn(20, 5, 10, 10)
# With Learnable Parameters
m <- nn_layer_norm(input$size()[-1])
# Without Learnable Parameters
m <- nn_layer_norm(input$size()[-1], elementwise_affine=FALSE)
# Normalize over last two dimensions
m <- nn_layer_norm(c(10, 10))
# Normalize over last dimension of size 10
m <- nn_layer_norm(10)
# Activating the module
output <- m(input)

}
}
