% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/wrapers.R
\name{torch_split}
\alias{torch_split}
\title{Split}
\usage{
torch_split(self, split_size, dim = 1L)
}
\arguments{
\item{self}{(Tensor) tensor to split.}

\item{split_size}{(int) size of a single chunk or
list of sizes for each chunk}

\item{dim}{(int) dimension along which to split the tensor.}
}
\description{
Splits the tensor into chunks. Each chunk is a view of the original tensor.
}
\details{
If \code{split_size} is an integer type, then \code{tensor} will
be split into equally sized chunks (if possible). Last chunk will be smaller if
the tensor size along the given dimension \code{dim} is not divisible by
\code{split_size}.

If \code{split_size} is a list, then \code{tensor} will be split
into \code{length(split_size)} chunks with sizes in \code{dim} according
to \code{split_size_or_sections}.
}
