% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-wavernn.R
\name{model_stretch2d}
\alias{model_stretch2d}
\title{Stretch2d}
\usage{
model_stretch2d(time_scale, freq_scale)
}
\arguments{
\item{time_scale}{the scale factor in time dimension}

\item{freq_scale}{the scale factor in frequency dimension}
}
\value{
Tensor shape:  (..., n_freq * freq_scale, n_time * time_scale)
}
\description{
Upscale the frequency and time dimensions of a spectrogram.
Pass the input through the Stretch2d layer.
}
\details{
forward param:
specgram  (Tensor): the input sequence to the Stretch2d layer (..., n_freq, n_time).
}
\examples{
if(torch::torch_is_installed()) {
 stretch2d = model_stretch2d(time_scale=10, freq_scale=5)

 input = torch::torch_rand(10, 100, 512)  # a random spectrogram
 output = stretch2d(input)  # shape: (10, 500, 5120)
}

}
