% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folder-dataset.R
\name{image_folder_dataset}
\alias{image_folder_dataset}
\title{Create an image folder dataset}
\usage{
image_folder_dataset(
  root,
  transform = NULL,
  target_transform = NULL,
  loader = NULL,
  is_valid_file = NULL
)
}
\arguments{
\item{root}{Root directory path.}

\item{transform}{A function/transform that takes in an PIL image and returns
a transformed version. E.g, \code{\link[=transform_random_crop]{transform_random_crop()}}.}

\item{target_transform}{A function/transform that takes in the target and
transforms it.}

\item{loader}{A function to load an image given its path.}

\item{is_valid_file}{A function that takes path of an Image file and check if
the file is a valid file (used to check of corrupt files)}
}
\description{
A generic data loader for images stored in folders.
See \code{Details} for more information.
}
\details{
This function assumes that the images for each class are contained
in subdirectories of \code{root}. The names of these subdirectories are stored
in the \code{classes} attribute of the returned object.

An example folder structure might look as follows:\preformatted{root/dog/xxx.png
root/dog/xxy.png
root/dog/xxz.png

root/cat/123.png
root/cat/nsdf3.png
root/cat/asd932_.png
}
}
\concept{datasets}
