\name{Sleep in Mammals}
\docType{data}
\alias{sleep}
\title{Sleep in Mammals: Ecological and Constitutional Correlates}
\description{

Data from which conclusions  were  drawn  in  the  article  "Sleep  in
Mammals: Ecological and Constitutional Correlates" by Allison, T.  and
Cicchetti, D. (1976), _Science_, November 12, vol. 194,  pp.  732-734.
Includes brain and body  weight,  life  span,  gestation  time,  time
sleeping, and predation and danger indices for 62 mammals.

Variables below for Mammals Data Set:
\itemize{
  \item bodywgt, body weight in kg
  \item brainwgt, brain weight in g
  \item nond, slow wave ("nondreaming") sleep (hrs/day)
  \item dream, paradoxical ("dreaming") sleep (hrs/day)
  \item sleep, total sleep (hrs/day) (sum of slow wave and paradoxical sleep)
  \item span, maximum life span
  \item gest, gestation time (days)
  \item pred, predation index (1-5)
                1 = minimum (least likely to be preyed upon)
                5 = maximum (most likely to be preyed upon)
  \item exp, sleep exposure index (1-5)
                1 = least exposed (e.g. animal sleeps in a
                    well-protected den)
                5 = most exposed
  \item danger, overall danger index (1-5)
                (based on the above two indices and other information)
                1 = least danger (from other animals)
                5 = most danger (from other animals)
}

For more details, see

Allison, Truett and Cicchetti, Domenic V. (1976), "Sleep  in  Mammals:
Ecological and Constitutional  Correlates",  _Science_,  November  12,
vol. 194, pp. 732-734.

The above data set can be freely used for non-commercial purposes  and
can be freely distributed (permission in  writing  obtained  from  Dr.
Truett Allison).

Submitted by Roger Johnson
rjohnson@carleton.edu


}
\usage{data(sleep)}
\format{A 62 x 10 numeric array}
\keyword{datasets}
