% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{listTonumeric}
\alias{listTonumeric}
\title{Convert x to numeric if x is a list.}
\usage{
listTonumeric(x)
}
\arguments{
\item{x}{A list of length Y without NULL values.}
}
\value{
x a numeric vector of length Y.
}
\description{
\code{listTonumeric} is used to convert x to a numeric type if x is a list.
}
\details{
This function is used as part of reading data from mongoDB using rmongodb.
Typically values will be stored as numeric vectors. However, if an NA is in
the original vector, rmongodb will convert to NULL prior to writing to the
database. This gets read from the database as a list of length Y rather than
a numeric of length Y with positions that were NA now with value NULL. The
function \code{nullToNA} converts the NULL values to NA, and this function
converts the list back to a numeric type.
}
\examples{
\dontrun{class(listTonumeric(list(1,2,3,4,NA,6,7)))}
}

