% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/methods-TxpTransFuncList.R
\docType{class}
\name{TxpTransFuncList-class}
\alias{TxpTransFuncList-class}
\alias{TxpTransFuncList}
\alias{as.TxpTransFuncList}
\title{List of TxpTransFunc objects}
\usage{
TxpTransFuncList(...)

as.TxpTransFuncList(x)
}
\arguments{
\item{...}{\link{TxpTransFunc} object or function to create \code{TxpTransFuncList}
object}

\item{x}{\code{list}, \code{function}, or \link{TxpTransFunc} object to coerce to
\code{TxpTransFuncList}}
}
\description{
Extension of \link[S4Vectors:SimpleList-class]{S4Vectors::SimpleList} that holds only \code{NULL} or
\link{TxpTransFunc} objects.
}
\details{
When \code{...} includes function objects, \code{TxpTransFuncList} will attempt to
coerce them to \link{TxpTransFunc} and return an error if any of the elements
cannot be coerced to \link{TxpTransFunc}.
}
\examples{
## Create TxpTransFunc objects
tf1 <- TxpTransFunc(function(x) x)
tf2 <- TxpTransFunc(function(x) sqrt(x))

## Create TxpTransFuncList 
tfl <- TxpTransFuncList(linear = tf1, sqrt = tf2, cube = function(x) x^3)
tfl[[3]](3) == 27
tfl[["sqrt"]](4) == 2

## Concatenate
c(tfl, tfl)

## names
names(c(tfl, tfl))

# note: names are printed as '' when missing; NULL is printed when list item
# is NULL
names(TxpTransFuncList(function(x) x, NULL))
TxpTransFuncList(function(x) x, NULL)

## coercion
as(function(x) x, "TxpTransFuncList")
as.TxpTransFuncList(function(x) x)

as(TxpTransFunc(function(x) x), "TxpTransFuncList")
as.TxpTransFuncList(TxpTransFunc(function(x) x))

as(list(function(x) x, sqrt = function(x) sqrt(x)), "TxpTransFuncList")
as.TxpTransFuncList(list(function(x) x, sqrt = function(x) sqrt(x)))
}
