% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/methods-TxpTransFunc.R
\docType{class}
\name{TxpTransFunc-class}
\alias{TxpTransFunc-class}
\alias{TxpTransFunc}
\title{Numeric transformation function}
\usage{
TxpTransFunc(x)
}
\arguments{
\item{x}{function, see details}
}
\description{
S4 class to store numeric transformation functions
}
\details{
\code{TxpTransFunc} inherits from a standard R function, but specifies a
single input and a numeric output of the same length.

Functions can be passed directly to \code{TxpTransFuncList} list and the
functions will be coerced to \code{TxpTransFunc}.

We have an imperfect system for dealing with primitive functions (e.g.,
\link[base:MathFun]{base::sqrt}).
To coerce primitives to TxpTransFunc's, we wrap them in another function
cal; wrapping the primitives obscures the original function and requires
the user to explore the function environment to understand the primitive
called.
We recommend wrapping primitives in separate functions to make the intent
clear, .e.g., \code{mysqrt <- function(x) sqrt(x)}.
}
\examples{
f1 <- function(x) "hello"
f2 <- function(x) 3
f3 <- function(x) x + 5
\dontrun{
t1 <- TxpTransFunc(x = f1) ## Produces error
t2 <- TxpTransFunc(x = f2) ## Produces error
}
t3 <- TxpTransFunc(x = f3)

## TxpTransFunc objects act as any other function
body(t3)
formals(t3)
t3(1:10)

## Coercion from functions
\dontrun{
TxpTransFuncList(f1, f2, f3) ## Produces error because f1, f3 not valid
}
}
