% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_smoother.R
\name{smoother.trackeRdata}
\alias{smoother.trackeRdata}
\title{Smoother for \code{\link{trackeRdata}} objects.}
\usage{
\method{smoother}{trackeRdata}(object, session = NULL,
  control = list(...), ...)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}}.}

\item{session}{The sessions to be smoothed. Default is all sessions.}

\item{control}{A list of parameters for controlling the smoothing
process. This is passed to \code{\link{smoother_control.trackeRdata}}.}

\item{...}{Arguments to be used to form the default \code{control}
argument if it is not supplied directly.}
}
\value{
An object of class \code{\link{trackeRdata}}.
}
\description{
Smoother for \code{\link{trackeRdata}} objects.
}
\examples{
\dontrun{
data('run', package = 'trackeR')
## unsmoothed speeds
plot(run, smooth = FALSE)
## default smoothing
plot(run, smooth = TRUE)
## smoothed with some non-default options
runS <- smoother(run, fun = 'median', width = 20, what = 'speed')
plot(runS, smooth = FALSE)
}
}
\seealso{
\code{\link{smoother_control.trackeRdata}}
}
