% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R, R/zzz_aliases.R
\name{generate_units}
\alias{generate_units}
\alias{generateBaseUnits}
\title{Generate and set base units.}
\usage{
generate_units(variable, unit, sport, ...)

generateBaseUnits(variable, unit, sport, ...)
}
\arguments{
\item{variable}{A vector of variables with user-specified units.}

\item{unit}{A vector with the user-specified units, corresponding
to variable (see details).}

\item{sport}{A vector of sports (amongst \code{'cycling'},
\code{'running'}, \code{'swimming'}) with each element
corresponding to \code{variable} and \code{unit}.}

\item{...}{Currently not used.}
}
\description{
Generate and set base units.
}
\details{
The avaialble units are
\itemize{

\item variables \code{latitude} and \code{longitude} with unit
\code{degree} (default)

\item variables \code{altitude}, \code{distance} with unit \code{m}
(default), \code{km}, \code{mi} or \code{ft}

\item variable \code{heart_rate} with unit \code{bpm} (default)

\item variable \code{speed} with unit \code{m_per_s} (default),
\code{km_per_h}, \code{ft_per_min}, \code{ft_per_s} or
\code{mi_per_h}

\item variable \code{cadence_running} with unit
\code{steps_per_min} (default; runing only)

\item variable \code{cadence_cycling} with unit \code{rev_per_min}
(default; cycling only)

\item variable \code{power} with unit \code{W} (Watt; default) or
\code{kW} (cycling only)

\item variable \code{temperature} with unit \code{C} (Celsius;
default) or \code{F}
}

Note that \code{generate_units} checks if the supplied combinations
of \code{variable} and \code{sport} are valid.
\code{generate_units} will not check if any of the supplied units
are correct for the corresponding combination of \code{variable}
and \code{sport}.
}
