% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{methods}
\name{JSONBackend}
\alias{JSONBackend}
\alias{jsonbackend}
\alias{JSONBackend-class}
\title{JSON backend for trackr}
\usage{
JSONBackend(file = normalizePath("./trackr_db_data.json"),
  data = list())
}
\arguments{
\item{file}{character. The json "database" to use as a trackr backend}

\item{data}{A list of records to pre-populate the backend with.}
}
\value{
A JSONBackend object, for use in creating a TrackrDB object.
}
\description{
A JSON-file based backend. This is the default backend in trackr.
}
\section{Slots}{

\describe{
\item{\code{data}}{list. An in-memory list representation of the data in the db}

\item{\code{file}}{character. The file containing the db ( to read from and write to)}

\item{\code{last_load}}{POSIXct. The last time \code{data} was updated from disk.}
}}


\note{
This is a reference class, which does NOT have standard copy-on-write
semantics

This function should generally not be called directly by end-users.
See instead \code{\link{jsonTDB}}
}
