% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffmpeg.R
\name{images.to.video}
\alias{images.to.video}
\title{Stitches images into a video file}
\usage{
images.to.video(image.dir = NULL, out.dir = NULL, vid.name = NULL,
  qual = 50, frame.rate = 10, overwrite = FALSE, silent = TRUE)
}
\arguments{
\item{image.dir}{character; directory containing images to stitch.}

\item{out.dir}{character; directory in which to store video.}

\item{vid.name}{character; file name given to video including extension.  mp4 currently works best.}

\item{qual}{numeric; the quality of the video rendered from 1-100\%. Defaults to 50\%.}

\item{frame.rate}{numeric; video frame rate in fps.}

\item{overwrite}{logical; should path described by vid.name  be overwritten if it exhists.}

\item{silent}{logical; should output of \code{system} call for ffmpeg operation be suppressed.}
}
\value{
Outputs a video of name "video.name+vid.ext".
}
\description{
Stitches images into a video file of type indicated by "vid.ext"
}
\details{
Assumes images are appended with a numeric sequence.
}
\examples{

#make some images
\donttest{
dir.create(paste0(tempdir(),"/images")) #make a directory to store images

a <- 2
b <- 3
theta <- seq(0,10*pi,0.01)
r <- a + b*theta
df <- data.frame(x=r*cos(theta), y=r*sin(theta)) # Cartesian coords
every.i <- 30
for(i in seq(1,length(theta),30)) {
  jpeg(paste0(tempdir(),"/images/image_",sprintf("\%03d",which(i==seq(1,length(theta),30))),".jpg"))
  with(df[1:i,],plot(x,y,xlim=range(df$x),ylim=range(df$y),col="red"))
  dev.off()
  }

images.to.video(image.dir=paste0(tempdir(),"/images"),
vid.name="spiral.mp4",out.dir=tempdir(),
frame.rate=5,qual=100,silent=TRUE,overwrite=TRUE)

file.exists(paste0(tempdir(),"/spiral.mp4"))
}
}
\seealso{
\code{\link{vid.to.images}}
}
