% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{infix}
\alias{infix}
\alias{\%||\%}
\title{Resolve a variable to a default when NULL}
\usage{
X \%||\% Y
}
\arguments{
\item{X, Y}{R objects, possibly \code{NULL}.}
}
\value{
\code{X}, if it is not \code{NULL}; otherwise \code{Y}.
}
\description{
This is a very simple infix function for the common TractoR idiom whereby
\code{NULL} is used as a default argument value, but later needs to be
resolved to a meaningful value if not overridden in the call. It returns its
first argument unless it is \code{NULL}, in which case it falls back on the
second argument.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18.
\url{https://www.jstatsoft.org/v44/i08/}.
}
\author{
Jon Clayden
}
