% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{resolvePath}
\alias{resolvePath}
\alias{paths}
\alias{relativePath}
\alias{matchPaths}
\alias{registerPathHandler}
\alias{expandFileName}
\alias{ensureFileSuffix}
\title{Functions for file name and path manipulation}
\usage{
resolvePath(path, ...)

relativePath(path, referencePath)

matchPaths(path, referencePath)

registerPathHandler(regex, handler)

expandFileName(fileName, base = getwd())

ensureFileSuffix(fileName, suffix, strip = NULL)
}
\arguments{
\item{path, referencePath}{Character vectors whose elements represent file
paths (which may or may not currently exist).}

\item{\dots}{Additional arguments to custom path handlers.}

\item{regex}{A Ruby-style regular expression.}

\item{handler}{A function taking and returning a string.}

\item{fileName}{A character vector of file names.}

\item{base}{If \code{fileName} is a relative path, this option gives the
base directory which the path is relative to. If \code{fileName} is an
absolute path, this argument is ignored.}

\item{suffix}{A character vector of file suffixes, which will be recycled if
shorter than \code{fileName}.}

\item{strip}{A character vector of suffixes to remove before appending
\code{suffix}. The intended suffix does not need to be given here, as the
function will not append it if the specified file name already has the
correct suffix.}
}
\value{
A character vector.
}
\description{
Functions for expanding file paths, finding relative paths and ensuring that
a file name has the required suffix.
}
\details{
The \code{resolvePath} function passes its arguments elementwise through any
matching path handler, and returns the resolved paths. Nonmatching elements
are returned as-is. \code{registerPathHandler} registers a new path handler
for special syntaxes, and is for advanced use only. \code{relativePath}
returns the specified \code{path}, expressed relative to
\code{referencePath}. \code{matchPaths} resolves a vector of paths against a
vector of reference paths. \code{expandFileName} returns the full path to
the specified file name, collapsing \code{".."} elements if appropriate.
\code{ensureFileSuffix} returns the specified file names with the requested
suffixes appended (if they are not already).
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18.
\url{https://www.jstatsoft.org/v44/i08/}.
}
\seealso{
\code{\link{normalizePath}} does most of the work for
\code{expandFileName}.
}
\author{
Jon Clayden
}
