% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read.service}
\alias{read.service}
\alias{read.service.blocks}
\title{BExIS access over a Webservice}
\usage{
read.service(datasetid, user = NULL, pswd = NULL, dec = ".",
  na.strings = "NA", fill = FALSE, sep = "\\t", quote = if
  (identical(sep, "\\n")) "" else "'\\"", fileEncoding = "UTF-8")

read.service.blocks(datasetid, user, pswd, dec = ".",
  na.strings = "NA", fill = FALSE, sep = "\\t", quote = if
  (identical(sep, "\\n")) "" else "'\\"", fileEncoding = "UTF-8")
}
\arguments{
\item{datasetid}{Integer BExIS ID of the requested dataset.}

\item{user}{User name on BExIS. If not provided, function will prompt input.}

\item{pswd}{Password on BExIS. If not provided, function will prompt input.}

\item{dec}{the character used in the file for decimal points.}

\item{na.strings}{a character vector of strings which are to be interpreted as NA values. Blank fields are also considered to be missing values in logical, integer, numeric and complex fields.}

\item{fill}{logical. If TRUE then in case the rows have unequal length, blank fields are implicitly added. See 'Details' of \code{?read.table}.}

\item{sep}{the field separator character. Values on each line of the file are separated by this character. If sep = "" (the default for read.table) the separator is ‘white space’, that is one or more spaces, tabs, newlines or carriage returns.}

\item{quote}{the set of quoting characters. To disable quoting altogether, use quote = "". See scan for the behaviour on quotes embedded in quotes. Quoting is only considered for columns read as character, which is all of them unless colClasses is specified.}

\item{fileEncoding}{character string: if non-empty declares the encoding to be used on a file (not a connection) so the character data can be re-encoded as they are written. See \code{\link[base:connections]{base::connections()}}.}
}
\description{
Read table from a web service. Inherits functionality of \code{read.table()}.
}
\details{
\code{read.service.blocks()} returns a data.frame array as a list of data.frames.
}
\author{
Dennis Heimann, Andreas Ostrowski
}
\keyword{internal}
