% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajhrmsm_gform.R
\name{trajhrmsm_gform}
\alias{trajhrmsm_gform}
\title{History Restricted MSM and Latent Class of Growth Analysis estimated with G-formula.}
\usage{
trajhrmsm_gform(
  degree_traj = c("linear", "quadratic", "cubic"),
  rep = 50,
  treatment,
  covariates,
  baseline,
  outcome,
  ntimes_interval,
  total_followup,
  time,
  time_values,
  identifier,
  var_cov,
  number_traj = 3,
  family = "poisson",
  obsdata
)
}
\arguments{
\item{degree_traj}{To specify the polynomial degree for modelling the time-varying treatment.}

\item{rep}{Number of repetition for the bootstrap.}

\item{treatment}{Name of the time-varying treatment.}

\item{covariates}{Names of the time-varying covariates (should be a list).}

\item{baseline}{Name of baseline covariates.}

\item{outcome}{Name of the outcome variable.}

\item{ntimes_interval}{Length of a time-interval (s).}

\item{total_followup}{Total length of follow-up.}

\item{time}{Name of the time variable.}

\item{time_values}{Measuring times.}

\item{identifier}{Name of the column of the unique identifier.}

\item{var_cov}{Names of the time-varying covariates.}

\item{number_traj}{Number of trajectory groups.}

\item{family}{Specification of the error distribution and link function to be used in the model.}

\item{obsdata}{Data in a long format.}
}
\value{
A list containing the following components:
\describe{
  \item{results_hrmsm_gform}{ Matrix of estimates for LCGA-MSM, obtained using the g-formula method.}
  \item{result_coef_boot}{ Matrix of estimates obtained with bootstrap.}
  \item{restraj}{ Fitted trajectory model.}
  \item{mean_adh}{ Matrix of mean adherence per trajectory group.}
}
}
\description{
Estimate parameters of LCGA-HRMSM using g-formula.
 and bootstrap to get standard errors.
}
\examples{
\donttest{
obsdata_long = gendata(n = 1000, format = "long", total_followup = 8,
timedep_outcome = TRUE,  seed = 945)
baseline_var <- c("age","sex")
years <- 2011:2018
variables <- c("hyper", "bmi")
covariates <- lapply(years, function(year) {
paste0(variables, year)})
treatment_var <- paste0("statins", 2011:2018)
var_cov <- c("statins","hyper", "bmi")
reshrmsm_gform = trajhrmsm_gform(degree_traj = "linear", rep=5 ,
treatment = treatment_var,covariates = covariates, baseline = baseline_var,
outcome = "y",var_cov = var_cov, ntimes_interval = 6, total_followup = 8,
 time = "time",time_values = years, identifier = "id",
number_traj = 3, family = "poisson", obsdata = obsdata_long)
reshrmsm_gform$results_hrmsm_gform
}
}
\author{
Awa Diop Denis Talbot
}
