% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{TrajAngles}
\alias{TrajAngles}
\title{Turning angles of a Trajectory}
\usage{
TrajAngles(trj, lag = 1, compass.direction = NULL)
}
\arguments{
\item{trj}{the trajectory whose angles are to be calculated.}

\item{lag}{Angles between every lag'th segment are calculated. Only applies
to non-directed walks, i.e. \code{compass.direction} is \code{NULL}.}

\item{compass.direction}{If not \code{NULL}, step angles are calculated
relative to this angle (in radians), otherwise they are calculated relative
to the previous step angle.}
}
\value{
Step angles in radians, normalised so that \code{-pi < angle <= pi}.
  If \code{compass.direction} is \code{NULL} (the default), the returned
  vector will have length \code{nrow(trj) - 2}, i.e. one angle for every pair
  of adjacent segments. If \code{compass.direction} is not \code{NULL}, the
  returned vector will have length \code{nrow(trj) - 1}, i.e. one angle for
  every segment.
}
\description{
Calculates the step angles (in radians) of each segment, either relative to
the previous segment or relative to the specified compass direction.
}
\details{
Note that since turning angles are circular quantities, i.e. 360° == 0°, it
is incorrect to treat them as linear quantities. In particular, do not
calculate arithmetic means or standard deviations of turning angles. See
Batschelet, (1981) for a detailed explanation and techniques for dealing with
circular quantities.

The turning angle before and after every zero-length segment will be
\code{NA}, since the angle of a zero-length segment is undefined. This
behaviour began in \code{trajr} version 1.5.0 (or development version
1.4.0.9000). Prior to this fix, the angle of a zero-length segment was
assumed to be 0, which led to incorrect turning angles being returned. One
approach to dealing with zero-length segments is to simply remove them from
the trajectory. See \code{\link{TrajFromTrjPoints}} for a means to achieve this.
}
\references{
Batschelet, E. (1981). Circular statistics in biology. ACADEMIC PRESS, 111
FIFTH AVE., NEW YORK, NY 10003, 1981, 388.
}
\seealso{
\code{\link{TrajStepLengths}},
  \code{\link{TrajMeanVectorOfTurningAngles}},
  \code{\link{TrajFromTrjPoints}}
}
