% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirn_autocorr.R
\name{TrajDirectionAutocorrelations}
\alias{TrajDirectionAutocorrelations}
\title{Direction autocorrelation}
\usage{
TrajDirectionAutocorrelations(trj, deltaSMax = round(nrow(trj)/4))
}
\arguments{
\item{trj}{The trajectory to calculate the directional autocorrelations for.}

\item{deltaSMax}{Maximum delta s to calculate, default is \eqn{1/4} the
number of segments in the trajectory.}
}
\value{
A data frame with class \code{TrajDirectionAutocorrelations} and 2
  columns, \code{deltaS} and \code{C}. Plotting this object displays a graph
  of the direction autocorrelation function, optionally with the location of
  the first local minimum marked
}
\description{
Calculates the autocorrelation of the track for \eqn{\Delta}s ranging from 1
to \code{deltaSMax}, based on Shamble et al. (2017). \code{trj} must have a
constant step length (see \code{\link{TrajRediscretize}}) i.e. all segments
in the trajectory must be the same length. deltaS is specified in number of
segments. Call \code{\link{TrajDAFindFirstMinimum}} to locate the first local
minimum which may be used to characterise directional periodicity in a
trajectory (note that the first local minimum may not exist).
}
\references{
Shamble, P. S., Hoy, R. R., Cohen, I., & Beatus, T. (2017).
  Walking like an ant: a quantitative and experimental approach to
  understanding locomotor mimicry in the jumping spider Myrmarachne
  formicaria. Proceedings of the Royal Society B: Biological Sciences,
  284(1858). doi:10.1098/rspb.2017.0308
}
\seealso{
\code{\link{TrajDAFindFirstMinimum}},
  \code{\link{plot.TrajDirectionAutocorrelations}}
}
