% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{TrajScale}
\alias{TrajScale}
\title{Scale a trajectory}
\usage{
TrajScale(trj, scale, units, yScale = scale)
}
\arguments{
\item{trj}{The trajectory to be scaled.}

\item{scale}{Scaling factor to be applied to the trajectory coordinates.}

\item{units}{Character specifying the spatial units after scaling, e.g. "m"
or "metres"}

\item{yScale}{Optional scaling factor to be applied to the y-axis, which may
be specified if the original coordinates are not square. Defaults to
\code{scale}.}
}
\value{
new scaled trajectory.
}
\description{
Scales the cartesian coordinates in a trajectory, for example, to convert
units from pixels to metres.
}
\examples{
set.seed(42)
trj <- TrajGenerate()
# original trajectory units are pixels, measured as having
# 47 pixels in 10 mm, so to convert to metres, scale the
# trajectory by the approriate factor, i.e. (size in metres) / (size in pixels).
scale <- .01 / 47
scaled <- TrajScale(trj, scale, "m")

}
