% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_research.r
\name{query}
\alias{query}
\alias{query_and}
\alias{query_or}
\alias{query_not}
\title{Create a traktok query}
\usage{
query(and = NULL, or = NULL, not = NULL)

query_and(q, field_name, operation, field_values)

query_or(q, field_name, operation, field_values)

query_not(q, field_name, operation, field_values)
}
\arguments{
\item{and, or, not}{A list of AND/OR/NOT conditions. Must contain one
or multiple lists with \code{field_name}, \code{operation}, and
\code{field_values} each (see example).}

\item{q}{A traktok query created with \code{query}.}

\item{field_name}{The field name to query against. One of:
"create_date", "username", "region_code", "video_id",
"hashtag_name", "keyword", "music_id", "effect_id",
"video_length".}

\item{operation}{One of: "EQ", "IN", "GT", "GTE", "LT", "LTE".}

\item{field_values}{A vector of values to search for.}
}
\value{
A traktok query.
}
\description{
Create a traktok query from the given parameters.
}
\details{
TikTok's query consists of rather complicated lists
dividing query elements into AND, OR and NOT:
\itemize{
\item \strong{and}: The and conditions specify that all the conditions in the list must be met
\item \strong{or}: The or conditions specify that at least one of the conditions in the list must be met
\item \strong{not}: The not conditions specify that none of the conditions in the list must be met
}

The query can be constructed by writing the list for each entry
yourself, like in the first example. Alternatively, traktok
provides convenience functions to build up a query using
\code{query_and}, \code{query_or}, and \code{query_not}, which
make building a query a little easier. You can learn more at
\url{https://developers.tiktok.com/doc/research-api-specs-query-videos#query}.
}
\examples{
\dontrun{
# using query directly and supplying the list
query(or = list(
  list(
    field_name = "hashtag_name",
    operation = "EQ",
    field_values = "rstats"
  ),
  list(
    field_name = "keyword",
    operation = "EQ",
    field_values = list("rstats", "API")
  )
))
# starting an empty query and building it up using the query_* functions
query() |>
  query_or(field_name = "hashtag_name",
           operation = "EQ",
           field_values = "rstats") |>
  query_or(field_name = "keyword",
           operation = "IN",
           field_values = c("rstats", "API"))
}

}
