% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_hidden.r, R/shorthands.r
\name{tt_videos_hidden}
\alias{tt_videos_hidden}
\alias{tt_videos}
\title{Get video metadata and video files from URLs}
\usage{
tt_videos_hidden(
  video_urls,
  save_video = TRUE,
  overwrite = FALSE,
  dir = ".",
  cache_dir = NULL,
  sleep_pool = 1:10,
  max_tries = 5L,
  cookiefile = NULL,
  verbose = interactive(),
  ...
)

tt_videos(...)
}
\arguments{
\item{video_urls}{vector of URLs or IDs to TikTok videos.}

\item{save_video}{logical. Should the videos be downloaded.}

\item{overwrite}{logical. If save_video=TRUE and the file already exists,
should it be overwritten?}

\item{dir}{directory to save videos files to.}

\item{cache_dir}{if set to a path, one RDS file with metadata will be written
to disk for each video. This is useful if you have many videos and want to
pick up where you left if something goes wrong.}

\item{sleep_pool}{a vector of numbers from which a waiting period is randomly
drawn.}

\item{max_tries}{how often to retry if a request fails.}

\item{cookiefile}{path to your cookiefile. Usually not needed after running
\link{auth_hidden} once. See \code{vignette("unofficial-api", package =
  "traktok")} for more information on authentication.}

\item{verbose}{should the function print status updates to the screen?}

\item{...}{handed to \code{tt_videos_hidden} (for tt_videos) and (further) to
\link{tt_request_hidden}.}
}
\value{
a data.frame containing post metadata.
}
\description{
\ifelse{html}{\figure{api-unofficial.svg}{options: alt='[Works on:
  Unofficial API]'}}{\strong{[Works on: Unofficial API]}}
}
\details{
The function will wait between scraping two videos to make it less
obvious that a scraper is accessing the site. The period is drawn randomly
from the \code{sleep_pool} and multiplied by a random fraction.

Note that the video file has to be requested in the same session as
the metadata. So while the URL to the video file is included in the
metadata, this link will not work in most cases.
}
\examples{
\dontrun{
tt_videos("https://www.tiktok.com/@tiktok/video/7106594312292453675")
}
}
