% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/video_scores.R
\name{video_scores}
\alias{video_scores}
\title{Run FER on YouTube video}
\usage{
video_scores(
  video,
  classes,
  nframes = 100,
  face_selection = "largest",
  start = 0,
  end = -1,
  uniform = FALSE,
  ffreq = 15,
  save_video = FALSE,
  save_frames = FALSE,
  save_dir = "temp/",
  video_name = "temp"
)
}
\arguments{
\item{video}{The URL of the YouTube video to analyze.}

\item{classes}{A character vector specifying the classes to analyze.}

\item{nframes}{The number of frames to analyze in the video. Default is 100.}

\item{face_selection}{The method for selecting faces in the video. Options are "largest", "left", or "right". Default is "largest".}

\item{start}{The start time of the video range to analyze. Default is 0.}

\item{end}{The end time of the video range to analyze. Default is -1 and this means that video won't be cut. If end is a positive number greater than start, the video will be cut from start to end.}

\item{uniform}{Logical indicating whether to uniformly sample frames from the video. Default is FALSE.}

\item{ffreq}{The frame frequency for sampling frames from the video. Default is 15.}

\item{save_video}{Logical indicating whether to save the analyzed video. Default is FALSE.}

\item{save_frames}{Logical indicating whether to save the analyzed frames. Default is FALSE.}

\item{save_dir}{The directory to save the analyzed frames. Default is "temp/".}

\item{video_name}{The name of the analyzed video. Default is "temp".}
}
\value{
A result object containing the analyzed video scores.
}
\description{
This function retrieves FER scores a specific number of frames extracted from YouTube video. It uses Python libraries for facial recognition and emotion detection in text, images, and videos.
}
\author{
Aleksandar Tomasevic <atomashevic@gmail.com>
}
