% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeMissings.R
\name{computeNvalid}
\alias{computeNvalid}
\title{Displays the amount of valid values in variables.}
\usage{
computeNvalid (x, variables = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame, data.table object or input data of class \code{"xpssFrame"}.}

\item{variables}{atomic character or character vector with the names of the variables.}
}
\value{
atomic numeric with the length of the data. Returns the amount of valid values of the variables.
}
\description{
R Implementation of the SPSS \code{Nvalid} function.
}
\details{
Performs a missing value operation. As opposite of \code{computeNmiss}, \code{computeNvalid} visualizies only the valid values of integer vectors or character vectors.

\code{variables} variables have to be same type.
}
\examples{
data(fromXPSS)

xpssCompute(x=fromXPSS, variables=c("V6","V7_2"), fun="computeNvalid")
}
\author{
Bastian Wiessner
}
\seealso{
Related Functions \code{\link{computeMiss}} , \code{\link{computeNmiss}} , \code{\link{computeSysmis}} ,\code{\link{computeValue}}
}
\keyword{internal}

