% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssDescriptives.R
\name{xpssDescriptives}
\alias{xpssDescriptives}
\title{Simple descriptive statistics}
\usage{
xpssDescriptives(x, variables, missing = "variable", statistics = c("mean",
  "max", "min", "stddev"), save = FALSE, ztrans = list(varname = NULL, zname
  = NULL))
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{variables}{atomic character or character vector with the name of the variables.}

\item{missing}{atomic character which specifiy the missing method. The method indicates what should happen when the data contains NAs. Default is \code{"variable"}.}

\item{statistics}{atomic chracter or character vector which determine the descriptiv statistics. Default are \code{"mean"}, \code{"max"}, \code{"min"}, \code{"stddev"}.}

\item{save}{logical indicator. TRUE adds the z-score of each variable to \code{x}. Default is FALSE.}

\item{ztrans}{list which specifies variables for z-transformation and name of z-transformed variables. Read Details for further information.}
}
\value{
Output is a list object with descriptive statistic parameters. The specific outcomes of the selected variables are stored in a list object. Every variable is stored in a different list element.

If the parameter \code{save} is TRUE, a matrix with z-transformed values will be appended at the end of the list. If \code{ztrans} is blank, the name of the matrix will be Z*varname*. Otherwise whether \code{ztrans} is not empty the user specified description in \code{zname} will be the name of the z-transformed matrix of the variable \code{varname}.
}
\description{
R Implementation of the SPSS Function \code{Descriptives}
}
\details{
The xpssDescriptives function provides a set of descriptive statistic tools.

\strong{\code{missing:}}
\tabular{rll}{

\tab \code{variable} \tab removes user-, and system-missing data explicitly for every variable.
\cr \tab \code{listwise} \tab performs a listwise-deletion.
\cr \tab \code{include} \tab includes all user-defined missing values.}

\strong{\code{statistics:}}
\tabular{rll}{

\tab \code{kurtosis} \tab calculates the bulge of the variable.
\cr \tab \code{max} \tab displays the maximum of the variable.
\cr \tab \code{mean} \tab calculates the arithmetic mean, respectively the midpoint of the variable.
\cr \tab \code{min} \tab displays the minimum of the variable.
\cr \tab \code{kurtosis} \tab calculates the bulge of the variable.
\cr \tab \code{range} \tab displays the span between the minimum and the maximum value.
\cr \tab \code{sekurtosis} \tab calculates the standrard error of the bulge of the variable.
\cr \tab \code{semean} \tab displays the standard error of the arithmetic mean.
\cr \tab \code{seskewness} \tab calculates the standrard error of the inclination of the variable.
\cr \tab \code{skewness} \tab calculates the inclination of the variable.
\cr \tab \code{stddev} \tab  displays the standard deviation of the variable.
\cr \tab \code{sum} \tab calculates the sum of each observation within the variable.
\cr \tab \code{variance} \tab displays the variance.}

\code{ztrans} input, is a list with elements varname and zname.  \code{varname} and  \code{zname} are either atomic characters or character vectors. \cr It is necessary that either both parameters are filled or blank.
}
\examples{
data(fromXPSS)

## Analyzing Variable V5, Output contains default statistics
xpssDescriptives(x=fromXPSS,
                 variables="V5")

## Analyzing Variable V7_1, Output contains default statistics
## and z-score of Variable V7_1
xpssDescriptives(x=fromXPSS,
                 variables="V7_1",
                 save = TRUE)

## Analyzing Variable V7_2, Output contains default statistics
## and z-score of Variable V7_2 store in myZname
xpssDescriptives(x=fromXPSS,
                 variables="V7_2",
                 save = TRUE,
                 ztrans = list(varname = "V7_2",
                               zname = "myZname"))

 ## Analyzing Variable V7_2, Output contains kurtosis, skewness, semean and mean
 ## missing values are included
 ## z-score get calculated and store in myZname

  xpssDescriptives(x=fromXPSS,
                 variables="V7_2",
                 statistics=c("kurtosis",
                               "skewness",
                               "semean",
                               "mean"),
                 missing="include",
                 save = TRUE,
                 ztrans = list(varname = "V7_2",
                               zname = "myZname"))
}
\author{
Bastian Wiessner
}

