% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssSample.R
\name{xpssSample}
\alias{xpssSample}
\title{Creates a sample}
\usage{
xpssSample(x, pct = NULL, n = NULL, from = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{pct}{atomic numeric, determines the percentage to keep.}

\item{n}{atomic numeric, specifies the number of cases to keep.}

\item{from}{atomic numeric, indicates the Basis for n.}
}
\value{
Returns a subset of the actual dataset.
}
\description{
R Implementation of the SPSS \code{SAMPLE} argument. Takes a sample from a xpssFrame object, data frame or matrix.
}
\details{
xpssSample takes a sample of the specified size from the elements of x either with or without replacement. The subset get specified by pct or n.

\code{pct} specifies a percentage value, for the amount of data which should be kept, allowed value range is from 0.01 to 1. \cr
\code{n} indicates the amount of values to keep. \cr
\code{from} determines the basis for n. \code{from} has to be higher then \code{n}. \cr
}
\examples{
data(fromXPSS)

xpssSample(fromXPSS, pct = 0.5)
}
\author{
Andreas Wygrabek
}
\seealso{
\code{\link{sample}}
}

