% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssSelectIf.R
\name{xpssSelectIf}
\alias{xpssSelectIf}
\title{Creates a subset of cases}
\usage{
xpssSelectIf(x, cond = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{cond}{logical expression for subsetting the data.}
}
\value{
Returns a subset of the actual dataset under the condition of the logical expression.
}
\description{
R Implementation of the SPSS \code{SELECT IF} argument. xpssSelectIf permanently selects cases for analysis based on logical conditions.
}
\details{
The condition to select cases are specified in a logical expression. These logical expressions can contain relational operators, logical operators and arithmetic operations.

\strong{NOTE:} For temporary case selection, specify \code{\link{xpssTemporary}} before \code{SELECT IF}.
}
\examples{
data(fromXPSS)

temp <- xpssSelectIf(x=fromXPSS, cond = "V3 == 1")

temp <- xpssSelectIf(x=fromXPSS, cond="V4 == 1 & V7_1 < 200")
}
\author{
Andreas Wygrabek
}
\seealso{
Related Functions \code{\link{xpssDoIf}}, \code{\link{xpssFilter}}, \code{\link{xpssTemporary}}
}

