% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssString.R
\name{xpssString}
\alias{xpssString}
\title{Creates string variables}
\usage{
xpssString(x, varname = NULL, fill = NA)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class "xpssFrame".}

\item{varname}{atomic character or character vector with the names of the variables which should be created.}

\item{fill}{atomic numeric or atomic character values to fill the variables. By default the value is NA for all new variables. It is possible to assign each new variable an own value to fill with.}
}
\value{
Returns the input data extended by the new variables
}
\description{
R implementation of the SPSS \code{STRING} function. Creates new string variables, which get appended at the end of the dataset.
}
\details{
xpssString creates new string variables, which get appended at the end of the dataset. The new variables are as long as the selected dataset. By default the new variables are blank and get filled with NA, otherwise every case for the selected variable gets filled with the filled value.
}
\examples{
data(fromXPSS)
xpssString(fromXPSS, varname = c("D","E"), fill = c("placeholder",NA))
}
\author{
Andreas Wygrabek
}
\seealso{
\code{\link{xpssNumeric}}
}

