uuids     <- replicate(100L, uuid(),     simplify = TRUE)
uuids_raw <- replicate(100L, uuid_raw(), simplify = FALSE)

# UUIDs below were generated by uuidtools.com.
# They are version 4 / variant 1 UUIDs. Sample
# size is equal to 100.
uuids_external_sample <- c(
    "2cf8e2bf-bd38-4c5f-a44c-b83196b9aa75",
    "4bd9841b-df98-41dd-a1ae-2138f775f539",
    "ee127515-b434-4fe8-af33-519fbf65617a",
    "53210b11-9768-4b6e-a87c-9ddbb8789fa7",
    "fc4c2fe6-dbd0-46b7-a6ba-839210cacfee",
    "047060f9-9d56-4068-aaa8-251c0bc87d8c",
    "03bc389e-4ce5-4624-abb5-4c4fde0db6cd",
    "c405b3c2-7c8f-4b2a-8906-d045d528610c",
    "5a1c4dd7-2106-4f20-bc5d-bebf2e1f08d9",
    "ac9221a0-c22c-4ad5-9a44-8ff090fe7799",
    "8c5f41e0-7a1a-498b-9627-05cd726235be",
    "75ea610c-0d52-4eb1-9a49-61b1a09a44ae",
    "b7f6be85-e99a-4198-9faf-8d3986f7ecfe",
    "9ad2c7b6-98b2-40cf-80bc-5a6133c48d17",
    "871e87c1-e0bd-40c4-9885-8d1bf32a4c9f",
    "b6c133b6-4625-4edc-a82b-31ed250caeb1",
    "77928816-4cf1-4f93-9ea7-04f996ee9875",
    "57ebea06-0604-49d4-88c4-01d01f35b454",
    "4751cafd-8ece-4166-8426-d7c002b5f005",
    "3eda7374-9f17-47ce-b1bc-20ac3ec5cf76",
    "11f8c4d3-9bcc-4496-8a35-7dcc588fc13d",
    "2ca74456-0fe4-48b4-8240-1623f495487f",
    "73ee4a5d-a220-400d-809b-75b9ab6ed3b0",
    "53399992-5261-4856-8da7-c9cf7b9b9765",
    "42870e85-5ac3-41cd-a4d9-fda39630e421",
    "65e235d2-20b2-4296-857e-313b1448fb56",
    "bb865ede-34e9-4111-a18f-7895cefaf16c",
    "21c5da9d-6d0d-44eb-af12-40c98b8dc343",
    "d061c1d1-ee6a-4c65-90b5-9d345a91f0a2",
    "9f8e8484-9efb-460f-9bde-e7ee4f0d79fd",
    "ed9c6a1c-e988-4410-b331-e3032d6087fb",
    "addaca4a-a785-4107-90c3-afdcdbd00cff",
    "38ce2de1-89d9-4039-b66e-449a309acdea",
    "0026709b-92ba-4d3d-811e-382f2798781a",
    "5e3707b7-e920-4278-a816-19778ad5a837",
    "b82d92cd-a27e-4c12-bb8c-fb17b0c1a442",
    "3a838649-7605-42e4-8aa2-85c4911e8608",
    "ec8b71b4-7635-4350-a5cb-ecc34646cdfa",
    "5941eca8-9fcc-45c0-bdde-4d5f68bd2365",
    "64a846ca-aac2-48d3-91ed-f995ade0f3bc",
    "a1208516-f602-4da1-81e0-d9de8cff7ee5",
    "d8c750d7-1246-44ae-8481-a549586a5fb6",
    "5fd11326-07ab-4c99-bd96-4214836f9cb7",
    "5143ee74-e08c-48d7-83e2-ad951f8158c0",
    "44e284e2-5eee-4ac4-83ab-e27605d16553",
    "5fceb453-a158-44d7-a0ac-b1917a7aba93",
    "e901860c-3eb3-4be3-82e7-cf71175f050e",
    "b78b2efb-3033-4810-87c7-95e73c16d77a",
    "df497064-a31b-4dae-95db-6d890935ca8a",
    "051d4f6f-fde2-44f7-bdf7-bd2c7762983e",
    "6347249f-e1e8-436a-8425-91c5c55beff5",
    "9cbe353b-5def-4937-bc61-ed5ebb1bd03b",
    "f40d3f17-a3ca-480f-bff3-dfc98d7c223d",
    "9a5f4d7b-a161-4481-90a9-78154b0a7d20",
    "dc15ce62-bc74-4cb1-ad22-450d7729f517",
    "3bfc2990-f47e-44e8-9ec1-981ff2fdb4f3",
    "2b576848-5cd3-4892-a0a0-6f33f2d0c567",
    "0733bebd-953c-4ceb-9df4-2904a30b4262",
    "89ce0e2b-7a79-474b-93db-66649a5c4014",
    "c4aff99a-3e49-48b5-92aa-ba7cf710327d",
    "d70c4319-6df3-4920-9537-d0231f5a2f5b",
    "7d6d540e-d671-4a69-b03c-141f59f11cf6",
    "d56d8b16-c503-4d61-9ba2-b18f51e4c38e",
    "69a833c2-b9ce-415f-aa5f-95cca1e40adc",
    "00f8ed43-a55a-4d6e-a98e-54c810b897af",
    "2681bd47-82c5-4db3-b052-bfcecc884935",
    "11c9b8f9-1c01-4b41-aa54-5cee8d458be0",
    "f14b9803-f1cd-44f2-b261-2dea7e2a56a2",
    "ffb77f11-68e3-4821-9b0f-8dfc2c5e4c70",
    "f778897c-283b-4b73-ba63-ff25a201875b",
    "ca468fed-30d2-4725-8059-27ad17d95cf9",
    "4d76513b-c6cb-4edf-9519-27339e65584f",
    "14157ff7-18a7-4bcf-a6c8-f4d85659ac51",
    "8c45926c-34cd-41e0-aa8e-e320c8f28230",
    "d9c4534a-6730-425d-b24b-7975f1a5fb61",
    "aaaf040a-4554-4f34-821e-da531ad2ae26",
    "045b9306-dd18-4621-ab2a-f4a50dc5b73a",
    "1e95504a-8823-4ae6-b05f-2d046b6ec48d",
    "8327de67-39fa-4ed4-9aa0-a316548c6b19",
    "5d82b6ec-fc44-42c7-b015-9d62e3779c02",
    "a517dcfd-b0f4-4053-830e-e18d4819516e",
    "2ba3ca25-c891-468f-b0be-6a169e911806",
    "1c1ba86d-2015-4d05-bb71-8e112e89bb56",
    "c1b3b129-b147-45dd-b131-58abaf7eb08c",
    "a0a43740-3623-4723-a03e-978676da4415",
    "dda064e4-6f5b-4e7a-8508-258aa1f6d0d8",
    "9e3c157d-c967-4305-98c5-b60553cba606",
    "25f48e20-899e-4ee8-ac4f-34c50b81a5dc",
    "7822b2ef-ea6c-4494-a18e-c254e88147cb",
    "65193d7e-8b73-4ff0-bc3c-5660f4052f03",
    "6f2cf3da-4a93-46ea-8729-8530fbc268d4",
    "7b6d791e-3eef-4cf2-985f-183434db1a34",
    "46af86c2-db8b-4c04-9f9b-dee5d9285cb6",
    "16b3faf0-2317-4a6e-bef8-bd58640511d8",
    "2703a33e-1d72-4032-9f44-1eaeeecf71e0",
    "a3bde524-7357-4f9c-806b-82feb0508abd",
    "a1d38dca-6657-4502-bec9-4bdfba43608e",
    "473b60bb-744a-4e1b-964e-b9e2bab45d15",
    "ad3d4a00-308a-40ee-a2ff-73197480c5b6",
    "59728c44-895c-4549-8cb5-a5464423c9e9")


# uuid() -----------------------------------------------------------------------


test_that("uuid() returns a character string", {
    out <- uuid()
    expect_type(out, "character")
    expect_length(out, 1L)
    expect_identical(nchar(out), 36L)
})

test_that("uuid() properly formats bytes internally", {
    # This test supposes uuid_is() returns valid
    # outputs. See below for related test blocks.
    expect_true(all(vapply_1l(uuids, uuid_is)))
})


# uuid_raw() -------------------------------------------------------------------


test_that("uuid_raw() returns a raw vector", {
    out <- uuid_raw()
    expect_type(out, "raw")
    expect_length(out, 16L)
})

test_that("uuid_raw() sets version 4 in values", {
    # The first nibble of byte 7 gives the version.
    # Since it must be equal to 4, any byte in the
    # range [0x40, 0x4f] is acceptable.,
    versions <- vapply(uuids_raw, `[[`, raw(1L), i = 7L)
    expect_true(all(versions >= 0x40 & versions <= 0x4f))
})

test_that("uuid_raw() sets default variant in values", {
    # The first two left-most bits of byte 9 give the
    # variant. Since they must be equal to 10, any byte
    # in the range [0x80, 0xbf] is acceptable. Check an
    # hexadecimal table for more information.
    variants <- vapply(uuids_raw, `[[`, raw(1L), i = 9L)
    expect_true(all(variants >= 0x80 & variants <= 0xbf))
})


# uuid_is() --------------------------------------------------------------------


test_that("uuid_is() returns a logical", {
    expect_true(uuid_is(uuid()))
    expect_false(uuid_is("2cf8e2bfbd384c5fa44cb83196b9aa75"))
    expect_false(uuid_is(1L))
    expect_false(uuid_is(""))
})

test_that("uuid_is() returns false for non version 4/variant 1 uuids", {
    # UUIDs below were generated by uuidtools.com.
    expect_false(uuid_is("fe6f9c06-bf77-11ed-b3a1-325096b39f47"))  # v1
    expect_false(uuid_is("000003e8-bf78-21ed-a300-325096b39f47"))  # v2
    expect_false(uuid_is("45a113ac-c7f2-30b0-90a5-a399ab912716"))  # v3
    expect_false(uuid_is("da5b8893-d6ca-5c1c-9a9c-91f40a2a3649"))  # v5
})

test_that("uuid_is() returns true for version 4/variant 1 uuids", {
    expect_true(all(vapply_1l(uuids_external_sample, uuid_is)))
})
