package jpsgcs.alun.infect;

import jpsgcs.alun.viewgraph.PaintableGraph;
import jpsgcs.alun.viewgraph.VertexRepresentation;
import jpsgcs.alun.viewgraph.GraphFrame;
import jpsgcs.alun.graph.Network;

import java.util.LinkedHashMap;
import java.util.Map;

public class InfectionFrame extends GraphFrame<Pady,Object>
{
	public InfectionFrame(InfectionModel m, int size)
	{
		super(getPaintableGraph(m,size),new InfectionLocator(4*size,2+2*size));
	}

	public static PaintableGraph<Pady,Object> getPaintableGraph(InfectionModel m, int size)
	{
		Network<Pady,Object> g = m.linkGraph();
		Map<Pady,VertexRepresentation> map = new LinkedHashMap<Pady,VertexRepresentation>();
		for (Pady v : g.getVertices())
			map.put(v,new PadyBlob(v,size));
			
		return new PaintableGraph<Pady,Object>(g,map);
	}
}
