% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epts.R
\name{epts_lookup}
\alias{epts_lookup}
\title{EPTS lookup function}
\usage{
epts_lookup(raw)
}
\arguments{
\item{raw}{numeric vector of raw EPTS scores}
}
\value{
numeric vector of EPTS scores as percentiles
}
\description{
A vectorised function to convert EPTS scores to percentiles for norm-related prediction of
patient survival after adult renal transplants. This calculator uses the most recent lookup
table published in March 2019 and using SRTR data from 2018 from the OPTN
website at https://optn.transplant.hrsa.gov/media/2973/epts_mapping_table_2018.pdf
}
\details{
This function requires the dplyr package to be installed.

References: https://optn.transplant.hrsa.gov/resources/allocation-calculators/epts-calculator/ and
https://optn.transplant.hrsa.gov/media/1511/guide_to_calculating_interpreting_epts.pdf
}
\examples{
epts_lookup(1.54) # 21
}
