% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pancreas.R
\name{p_pass}
\alias{p_pass}
\title{P-PASS pre-procurement pancreas suitability score}
\usage{
p_pass(age, bmi, icu, c.arr, Na, amylase = NULL, lipase = NULL, norad,
  dopam)
}
\arguments{
\item{age}{numeric vector of donor ages in years}

\item{bmi}{numeric vector of donor body mass index (BMI)}

\item{icu}{numeric vector of length of donor ICU stay in days}

\item{c.arr}{numeric vector for duration of cardiac arrest (use 0 if no cardiac arrest)}

\item{Na}{numeric vector of donor serum sodium in mmmol/l}

\item{amylase}{numeric vector of donor serum amylase in IU/l (0 if not available)}

\item{lipase}{numeric vector of donor serum lipase in IU/l (0 if not available)}

\item{norad}{numeric vector of noradrenaline (0 if not used)}

\item{dopam}{numeric vector of dopamine or dobutamine (0 if not used)}
}
\value{
numeric vector of P-PASS scores
}
\description{
A vectorised function to calculate the P-PASS pre-procurement pancreas allocation suitability
score used in the Eurotransplant area. The score are between 9 and 27, and in a study published
by Vinkers et al. in 2008, pancreata with P-PASS score less than 17 were three times more likely
to be transplanted than those with scores of 17 or more.
}
\details{
At least one of amylase or lipase is needed for each case, but this function can take datasets
with a mixture of amylase and lipase levels and will allocate points based on the higher points
for cases when both are provided.

Reference: Vinkers MT, Rahmel AO, Slot MC, et al. How to recognize a suitable pancreas donor: a
Eurotransplant study of preprocurement factors. Transplant Proc 2008; 40(5):1275-8.
}
\examples{
# as a single case
p_pass(age = 25, bmi = 19, icu = 0, c.arr = 0, Na = 135,
      amylase = 101, lipase = 120, norad = 0, dopam = 0) # 9

# as a vector with mixed amylase and lipase availability
p_pass(age = c(25, 31, 45), bmi = c(18, 22, 35), icu = c(2, 5, 10), c.arr = c(0, 4, 10),
       Na = c(135, 157, 164), amylase = c(120, NA, 400), lipase = c(155, 170, NA),
      norad = c(0, 0.02, 0.06), dopam = c(0, 5, 11)) # 9, 19, 25

# as a vector with all lipase values missing
p_pass(age = c(25, 31, 45), bmi = c(18, 22, 35), icu = c(2, 5, 10), c.arr = c(0, 4, 10),
       Na = c(135, 157, 164), amylase = c(120, 145, 400), lipase = c(NA, NA, NA),
       norad = c(0, 0.02, 0.06), dopam = c(0, 5, 11)) # 9, 19, 25
}
