% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fitted.transreg}
\alias{fitted.transreg}
\title{Fitted values}
\usage{
\method{fitted}{transreg}(object, stack = NULL, ...)
}
\arguments{
\item{object}{object of class \code{transreg}}

\item{stack}{character "sta" (standard stacking) or "sim" (simultaneous stacking)}

\item{...}{(not applicable)}
}
\value{
Returns fitted values.
The output is a numerical vector
with one entry for sample.
}
\description{
Extracts fitted values
}
\examples{
#--- simulation ---
set.seed(1)
n0 <- 100; n1 <- 10000; n <- n0 + n1; p <- 500
X <- matrix(rnorm(n=n*p),nrow=n,ncol=p)
beta <- rnorm(p)
prior <- beta + rnorm(p)
y <- X \%*\% beta

#--- train-test split ---
foldid <- rep(c(0,1),times=c(n0,n1))
y0 <- y[foldid==0]
X0 <- X[foldid==0,]
y1 <- y[foldid==1]
X1 <- X[foldid==1,]

object <- transreg(y=y0,X=X0,prior=prior)

#--- fitted values ---
y0_hat <- fitted(object)
mean((y0-y0_hat)^2)

#--- predicted values ---
y1_hat <- predict(object,newx=X1)
mean((y1-y1_hat)^2) # increase in MSE?

}
\references{
Armin Rauschenberger
\href{https://orcid.org/0000-0001-6498-4801}{\figure{orcid.png}{(iD)}},
Zied Landoulsi
\href{https://orcid.org/0000-0002-2327-3904}{\figure{orcid.png}{(iD)}},
Mark A. van de Wiel
\href{https://orcid.org/0000-0003-4780-8472}{\figure{orcid.png}{(iD)}},
and Enrico Glaab
\href{https://orcid.org/0000-0003-3977-7469}{\figure{orcid.png}{(iD)}}
(2022).
"Penalised regression with multiple sets of prior effects".
\emph{Manuscript in preparation.}
\doi{10.48550/arXiv.2212.08581}
\email{armin.rauschenberger@uni.lu}
}
\seealso{
Methods for objects of class \link{transreg}
include \code{\link[=coef.transreg]{coef}}
and \code{\link[=predict.transreg]{predict}}.
}
