% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_searches.R
\name{make_search}
\alias{make_search}
\title{Search objects constructor}
\usage{
make_search(
  id,
  travel_time = NA,
  coords = NA,
  departure_time = NA,
  arrival_time = NA,
  transportation = list(type = "driving"),
  ...
)
}
\arguments{
\item{id}{Used to identify this specific search in the results array. MUST be unique among all searches.}

\item{travel_time}{Travel time in seconds. Maximum value is 14400 (4 hours)}

\item{coords}{The coordinates of the location we should start the search from. Must use this format: list(lat = 0, lng = 0)}

\item{departure_time}{Date in extended ISO-8601 format}

\item{arrival_time}{Date in extended ISO-8601 format}

\item{transportation}{Transportation mode and related parameters.}

\item{...}{Any additional parameters to pass. Some functions require extra parameters to work. Check their API documentation for details.}
}
\value{
A data.frame wrapped in a list.
It is constructed in a way that allows jsonlite::toJSON to correctly transform it into a valid request body
}
\description{
Searches based on departure or arrival times.
Departure: Leave departure location at no earlier than given time. You can define a maximum of 10 searches
Arrival: Arrive at destination location at no later than given time. You can define a maximum of 10 searches
}
\seealso{
See \code{\link{time_map}} for usage examples
}
