% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrawlCorrelationFunctions.R
\name{acf_DExp}
\alias{acf_DExp}
\title{Autocorrelation function of the double exponential trawl function}
\usage{
acf_DExp(x, w, lambda1, lambda2)
}
\arguments{
\item{x}{The argument (lag) at which the autocorrelation function associated
with the double exponential trawl function will be evaluated}

\item{w}{parameter in the double exponential trawl}

\item{lambda1}{parameter in the double exponential trawl}

\item{lambda2}{parameter in the double exponential trawl}
}
\value{
The autocorrelation function of the double exponential trawl function
 evaluated at x
}
\description{
This function computes the autocorrelation function associated with the double
exponential trawl function.
}
\details{
The trawl function is parametrised by parameters \eqn{0\le w\le 1}
 and \eqn{\lambda_1, \lambda_2 > 0}  as follows: \deqn{g(x) = w e^{\lambda_1
 x}+(1-w) e^{\lambda_2 x},  \mbox{ for }  x \le 0.} Its autocorrelation
 function is given by: \deqn{r(x) = (w e^{-\lambda_1 x}/\lambda_1+(1-w)
 e^{-\lambda_2 x}/\lambda_2)/c,  \mbox{ for } x \ge 0,} where \deqn{c =
 w/\lambda_1+(1-w)/\lambda_2.}
}
\examples{
#Evaluate the trawl autocorrelation function at x=1
acf_DExp(1,0.3,0.1,2)
#Plot the trawl autocorrelation function
plot(acf_DExp((0:10),0.3,0.1,2))
}
