% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop.things.R
\name{drop.things}
\alias{drop.things}
\alias{drop.singles}
\alias{drop.fossils}
\alias{drop.livings}
\title{Drop things from a treats object}
\usage{
drop.things(treats, what)

drop.fossils(treats)

drop.livings(treats)

drop.singles(treats)
}
\arguments{
\item{treats}{\code{treats} data.}

\item{what}{what to drop. Can be \code{"fossils"}, \code{"livings"} or \code{"singles"} (non-bifurcating nodes).}
}
\value{
This function outputs either a \code{"phylo"} object if no traits where generated or a \code{treats} object that is a list of at least two elements: \code{$tree}, a \code{"phylo"} object and \code{$data}, a \code{"matrix"} of the trait values.
}
\description{
Remove fossils or living species or non-bifurcating nodes (singles) from \code{treats} objects or \code{phylo} objects.
}
\details{
\emph{NOTE} that dropping living or fossils species DOES NOT drop associated internal nodes and edge lengths. To drop both fossil/living taxa AND internal nodes, you can use for example: \code{drop.things(drop.things(my_data, what = "fossils"), what = "singles")}.
}
\examples{
## A random tree with fossils and traits and internal nodes every 0.5 times
set.seed(3)
my_data <- treats(stop.rule = list(max.taxa = 20),
                bd.params = list(speciation = 1, extinction = 1/3),
                traits    = make.traits(), save.steps = 0.5)

## A tree with 20 tips and 54 nodes
my_data$tree
## And a dataset with 74 rows
dim(my_data$data)

## Removing the fossil species
drop.things(my_data, what = "fossils")$tree
dim(drop.fossils(my_data)$data)

## Removing the living species
drop.things(my_data, what = "livings")$tree
dim(drop.livings(my_data)$data)

## Removing the internal nodes
drop.things(my_data, what = "singles")$tree
dim(drop.singles(my_data)$data)

## Removing the internal nodes AND the fossils
drop.singles(drop.fossils(my_data))

}
\seealso{
\code{\link{treats}} \code{\link{plot.treats}}
}
\author{
Thomas Guillerme
}
