% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilization.R
\name{centreOfMassAngle}
\alias{centreOfMassAngle}
\title{Returns the angle between CM modulus and the tree weight vector}
\usage{
centreOfMassAngle(object)
}
\arguments{
\item{object}{an object of \code{CM} class}
}
\value{
a real number in radians
}
\description{
This function is mainly needed to compute the moment of the tree. The angle is need to compute the projection of the tree weight normal to the CM modulus
}
\examples{
library(treecm)
data(stonePine1TreeData)
vectors <- treeVectors(stonePine1TreeData)
CM <- centreOfMass(vectors)
print(centreOfMassAngle(CM))
treeMoment <- buildTreeMomentObject(
 centreOfMassModulus(CM)
 , treeTotalBiomass(stonePine1TreeData)
 , centreOfMassAngle(CM)
 )
}
\seealso{
Other Stabilization: \code{\link{anchorRange}},
  \code{\link{centreOfMassModulus}},
  \code{\link{getPlinthForce}},
  \code{\link{logPathSelection}},
  \code{\link{toCartesianXYZ}}
}

