% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treecm.R
\name{importFieldData}
\alias{importFieldData}
\title{Imports field data from csv file}
\usage{
importFieldData(fileName, dst, branchesAllometryFUN, bCM = 1)
}
\arguments{
\item{fileName}{Name of csv file holding field data}

\item{dst}{Fresh density of wood of the tree}

\item{branchesAllometryFUN}{the function that should compute branch biomass from its diameter}

\item{bCM}{Estimated position of the centre of mass of branches, a real number from 0.01 (CM at branch base) to 1.00 (CM at branch tip). As a rule of thumb, average live branches, with an average amount of foliage, have CM approx. from \eqn{1/3} to \eqn{2/3} of their length. bCM = 1.0 (default value)}
}
\value{
a list of 4 elements: field data, wood fresh density, allometryFUN function and branches CM
}
\description{
Imports \code{csv} file holding field recorded data returning a list holding field and other key data provided as arguments. 

Field measures to be taken on logs and branches include:
\itemize{
  \item{\bold{Azimuth} (\code{azimuth}): mean angle of orientation of the branch or log measured from the base of the tree (usually with magnetic north as reference, measured clockwise), \emph{mandatory}}
  \item{\bold{Diameter at base} (\code{dBase}): diameter at insertion point on the stem, for branches, diameter of the lower section for logs, \emph{mandatory}}
  \item{\bold{Diameter at top} (\code{dTip}): always 0 for branches, diameter of the higher section for logs, defaults to 0, \emph{mandatory} only for logs}
  \item{\bold{Length} (\code{length}): length of logs or branches, \emph{mandatory} for logs, \emph{mandatory} for branches only if their slenderness coefficient is to be computed}
  \item{\bold{Distance} (\code{tipD}): length of branch or log projection on the ground, starting from tree base to tip of branch or log, \emph{mandatory}}
  \item{\bold{Height} (\code{height}): height of branch insertion on the stem or height of lower section of the log, to be used to compute \code{z} coordinate of CM, defaults to NA, \emph{mandatory} only for \code{z} determination of CM}
  \item{\bold{Tilt} (\code{tilt}): mean branch tilt or log tilt from the horizontal plane (eg a vertical branch is 90 degrees, an horizontal branch is 0 degrees), to be used to compute \code{z} coordinate of CM, defaults to 0, \emph{mandatory} only for \code{z} determination of CM. Note however that the tree tip should be considered as a branch, not a log, in order to account for foliage biomass. In this case the tilt value should be recorded otherwise it would default to 0, \emph{ie} an horizontal branch}
  \item{\bold{To be pruned} (\code{toBePruned}): a boolean value, defaults to FALSE, \emph{optional}}
  \item{\bold{Path to tip} (\code{pathToTip}): a boolean value TRUE on logs and branches that make part of the ``main stem'' of the tree, defaults to FALSE, \emph{optional}}
}
}
\seealso{
\code{\link{getCoordinatesAndMoment}}
}

