% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectCharacterType.R
\name{detectCharacterType}
\alias{detectCharacterType}
\title{Function to detect whether a character is continuous or discrete}
\usage{
detectCharacterType(dat, cutoff = 0.1)
}
\arguments{
\item{dat}{A vector of data}

\item{cutoff}{Cutoff value for deciding if numeric data might actually be
discrete: if nlev is the number of levels and n the length of dat, then
nlev / n should exceed cutoff, or the data will be classified as discrete}
}
\value{
Either "discrete" or "continuous"
}
\description{
This function detects whether a given vector is a continuous
(e.g., with values 2.45, 9.35, and so on) or a discrete
(e.g., with values blue, red, yellow) character.
}
\examples{
data(anolis)
detectCharacterType(anolis$dat[, 1])
}
