% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_cophylo.R
\name{event_history}
\alias{event_history}
\alias{event_history.cophy}
\alias{summary.cophy}
\title{Summarize a cophylogenetic set}
\usage{
event_history(cophy)

\method{event_history}{cophy}(cophy)

\method{summary}{cophy}(object, ...)
}
\arguments{
\item{cophy}{Cophylogenetic set}

\item{object}{An object of class `cophy`}

\item{...}{Further arguments used in generic classes}
}
\value{
Summary returns NULL.
}
\description{
Several utility functions for cophylogenetic set summarization.
Including functions for printing an entire summary, and a summary of each
part: host_tree, symb_tree, association_mat, and event_history.
}
\details{
The summary for a cophylogenetic set outputs a summary of the host
 tree and the symbiont tree.
The number of rows and columns of the association matrix, and a summary of
 the event_history.
}
\section{Functions}{
\itemize{
\item \code{event_history}: Returns event history of a cophylogenetic set

\item \code{event_history.cophy}: Returns event history of a cophylogenetic set
}}

\examples{
h_lambda <- 1.0
h_mu <- 0.3
c_lambda <- 0.0
s_lambda <- 1.0
s_mu <- 0.3
s_her <- 0.0
host_symb_sets <- sim_cophylo_bdp(hbr = h_lambda,
                                  hdr = h_mu,
                                  sbr = s_lambda,
                                  cosp_rate = c_lambda,
                                  sdr = s_mu,
                                  host_exp_rate = s_her,
                                  time_to_sim = 1.0,
                                  numbsim = 1)
summary(host_symb_sets[[1]])
}
\seealso{
sim_cophylo_bdp, summary for the generic, multiCophy, c.cophy
}
\author{
Wade Dismukes and Emmanuel Paradis
}
