## ----generate-tree-like-data, fig.asp=1, fig.cap="Figure 1. A scatter plot of tree-like toy data generated by Treefit"----
star.tree_like <- treefit::generate_2d_n_arms_star_data(500, 3, 0.1)
plot(star.tree_like)

## ----generate-less-tree-like-data, fig.asp=1, fig.cap="Figure 2. A scatter plot of noisy toy data generated by Treefit"----
star.less_tree_like <- treefit::generate_2d_n_arms_star_data(500, 3, 0.8)
plot(star.less_tree_like)

## ----estimate-tree-like-data--------------------------------------------------
fit.tree_like <- treefit::treefit(list(expression=star.tree_like),
                                  name="tree-like")
# Save the analytsis result to use other tutorials.
saveRDS(fit.tree_like, "fit.tree_like.rds")
fit.tree_like

## ----plot-tree-like-data-estimation-result, fig.cap="Figure 3. The output for the tree-like data shown in Figure 1"----
plot(fit.tree_like)

## ----estimate-less-tree-like-data---------------------------------------------
fit.less_tree_like <- treefit::treefit(list(expression=star.less_tree_like),
                                       name="less-tree-like")
# Save the analytsis result to use other tutorials.
saveRDS(fit.less_tree_like, "fit.less_tree_like.rds")
fit.less_tree_like

## ----plot-less-tree-like-data-estimation-result, fig.cap="Figure 4. The output for the noisy data shown in Figure 2"----
plot(fit.less_tree_like)

## ----plot-estimation-results, fig.cap="Figure 5. Comparison of the plots shown in Figure 3 and Figure 4."----
plot(fit.tree_like, fit.less_tree_like)

