% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeman-declaration.R, R/treemen-declaration.R
\docType{class}
\name{TreeMan-class}
\alias{TreeMan-class}
\alias{TreeMan-method}
\alias{[,TreeMan,character-method}
\alias{[[,TreeMan,character-method}
\alias{as.character,TreeMan-method}
\alias{cTrees,TreeMan-method}
\alias{print,TreeMan-method}
\alias{show,TreeMan-method}
\alias{str,TreeMan-method}
\title{TreeMan-class}
\usage{
\S4method{[[}{TreeMan,character}(x, i)

\S4method{[}{TreeMan,character}(x, i)

\S4method{as.character}{TreeMan}(x)

\S4method{show}{TreeMan}(object)

\S4method{str}{TreeMan}(object, max.level = 2L, ...)

\S4method{print}{TreeMan}(x)

\S4method{cTrees}{TreeMan}(x, ...)
}
\arguments{
\item{x}{\code{TreeMan} object}

\item{i}{node ID or slot name}

\item{object}{\code{TreeMan} object}

\item{max.level}{\code{str()} maximum number of levels to show}

\item{...}{additional tree objects}
}
\description{
S4 class for representing phylogenetic trees as a list of nodes.
}
\details{
A \code{TreeMan} object holds a list of nodes. The idea of the \code{TreeMan}
class is to make adding and removing nodes as similar as possible to adding
and removing elements in a list. Note that internal nodes and tips are
both considered nodes. Trees can be polytomous but not unrooted.


Each node within the \code{TreeMan} \code{ndlst} contains the following data slots:
\itemize{
   \item \code{id}: character string for the node ID
   \item \code{txnym}: name of taxonomic clade (optional)
   \item \code{spn}: length of the preceding branch
   \item \code{prid}: IDs of the preceding nodes to the root
   \item \code{ptid}: IDs of the immediately connecting nodes
   \item \code{kids}: descending tip IDs
   \item \code{pd}: phylogenetic diversity represented by node
   \item \code{prdst}: pre distance(distance to root if rooted or
   most distal tip if unrooted)
}
These data slots are updated whenever a node is modified, added or removed.

See below in 'Examples' for these methods in use.
}
\section{Slots}{

\describe{
\item{\code{ndlst}}{list of nodes}

\item{\code{nds}}{vector of node ids that are internal nodes}

\item{\code{nnds}}{numeric of number of internal nodes in tree}

\item{\code{tips}}{vector of node ids that are tips}

\item{\code{ntips}}{numeric of number of internal nodes in tree}

\item{\code{all}}{vector of all node ids}

\item{\code{nall}}{numeric of number of all nodes in tree}

\item{\code{age}}{numeric of max root to tip distance}

\item{\code{pd}}{numeric of total branch length of tree}

\item{\code{ext}}{vector of node ids of all tips with 0 age}

\item{\code{exc}}{vector of node ids of all tips with age > 0}

\item{\code{wspn}}{logical, do nodes have spans}

\item{\code{ultr}}{logical, do all tips end at 0}

\item{\code{ply}}{logical, is tree bifurcating}

\item{\code{tol}}{numeric of tolerance for determining extant}

\item{\code{root}}{character of node id of root, if no root then empty character}
}}
\examples{
library(treeman)
# Generate random tree
tree <- randTree(10)
# Print to get basic stats
print(tree)
# Currently available methods
tree['tips']  # return all tips IDs
tree['nds']  # return all internal node IDs
tree['ntips']  # count all tips
tree['nnds']  # count all internal nodes
tree['root']  # identify root node
tree[['t1']]  # return t1 node object
tree['pd']  # return phylogenetic diversity
tree['age']  # return age of tree
tree['ultr']  # is ultrametric?
tree['ply']  # is polytomous?
tree['ext']  # return all extant tip IDs
tree['exc']  # return all extinct tip IDs
tree <- setTol(tree, 10)  # reset tolerance, default 1e-8
# now tol is higher more tips will be classed as extant
tree['ext']
# Because all nodes are lists with metadata we can readily
#  get specific information on nodes of interest
nd <- tree[['n2']]
print(nd)
# And then use the same syntax for the tree
nd['age']  # .... nkids, pd, etc.
}
\seealso{
\code{\link{randTree}}, \code{\link{Node-class}}, \code{\link{viz}}
}

