% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server-methods.R
\name{taxaResolve}
\alias{taxaResolve}
\title{Resolve taxonmic names online}
\usage{
taxaResolve(
  nms,
  batch = 100,
  datasource = 4,
  genus = TRUE,
  cache = FALSE,
  parent = NULL
)
}
\arguments{
\item{nms}{vector of names}

\item{batch}{size of the batches to be queried}

\item{datasource}{ID number of the datasource}

\item{genus}{boolean, if true will search against GNR with just the genus
name for names that failed to resolve using the full species name}

\item{cache}{T/F, create a local cache of downloaded names?}

\item{parent}{specify parent of all names to prevent false names}
}
\description{
Resolve taxonomic names via the Global Names Resolver.
}
\details{
Returns dataframe containing GNR metadata for each name wames
that cannot be resolved are returned as NA. Various datasources are 
available, see \url{http://resolver.globalnames.org/data_sources} for a
list and IDs. Default is 4 for NCBI.
Will raise a warning if connection fails and will return NULL.
}
\examples{
my_lovely_names <- c ('Gallus gallus', 'Pongo pingu', 'Homo sapiens',
                      'Arabidopsis thaliana', 'Macaca thibetana', 'Bacillus subtilis')
res <- taxaResolve (nms=my_lovely_names)
length(colnames(res))  # 10 different metadata for returned names including original search name
# let's look at the lineages
lineages <- strsplit(as.vector(res$lineage), '\\\\|')
print(lineages[[6]])  # the bacteria has far fewer taxonomic levels
}
\seealso{
\code{\link{searchTxnyms}}, \code{\link{setTxnyms}}, \code{\link{getNdsFrmTxnyms}}
}
