% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_treemap_subgroup_border.R
\name{geom_treemap_subgroup_border}
\alias{geom_treemap_subgroup_border}
\title{A 'ggplot2' geom to draw a border around a subgroup of treemap tiles.}
\usage{
geom_treemap_subgroup_border(mapping = NULL, data = NULL,
  stat = "identity", position = "identity", na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, fixed = F, ...)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{Standard
geom arguments as for `ggplot2::geom_rect`.}

\item{fixed}{If `TRUE`, the alternative 'fixed' tile layout algorithm will be
used.}
}
\description{
When `geom_treemap` is used with the 'subgroup' aesthetic to subgroup
treemap tiles, `geom_treemap_subgroup_border` can be used to draw a
border around each subgroup.
}
\details{
`geom_treemap_subgroup_border` requires `area` and `subgroup` aesthetics.
Several other standard 'ggplot2' aesthetics are supported (see Aesthetics).

All `treemapify` geoms added to a plot should have the same value for
`fixed`, or they will not share a common layout (see `geom_treemap` for
details on the layout algorithms).
}
\section{Aesthetics}{


\itemize{
  \item area (required)
  \item subgroup (required)
  \item colour
  \item size
  \item linetype
  \item alpha
}
}

\examples{

ggplot2::ggplot(G20, ggplot2::aes(area = gdp_mil_usd, fill = hdi,
                                  subgroup = region)) +
  geom_treemap() +
  geom_treemap_subgroup_border()

}
\seealso{
geom_treemap, geom_treemap_subgroup_text
}
