% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lift.R
\name{lift}
\alias{lift}
\alias{plot.lift}
\title{Gain and lift charts}
\usage{
lift(prob, y, pos.class = NULL, cumulative = TRUE, nbins = 0)

\method{plot}{lift}(
  x,
  refline = TRUE,
  refline.col = 2,
  refline.fill = 2,
  refline.lty = "dashed",
  refline.lwd = 1,
  ...
)
}
\arguments{
\item{prob}{Vector of predicted probabilities.}

\item{y}{Vector of binary (i.e., 0/1) outcomes. If \code{y} is coded as
anything other than 0/1, then you must specify which of the two categories
represents the "positive" class (i.e., the class for which the probabilities
specified in \code{prob} correspond to) via the \code{pos.class} argument.}

\item{pos.class}{Numeric/character string specifying which values in \code{y}
correspond to the "positive" class. Default is \code{NULL}. (Must be
specified whenever \code{y} is not coded as 0/1, where 1 is assumed to
represent the "positive" class.)}

\item{cumulative}{Logical indicating whether or not to compute cumulative
lift (i.e., gain). Default is \code{TRUE}.}

\item{nbins}{Integer specifying the number of bins to use when computing
lift. Default is 0, which corresponds to no binning. For example, setting
\code{nbins = 10} will result in computing lift within each decile of the
sorted probabilities.}

\item{x}{An object of class \code{"lift"}.}

\item{refline}{Logical indicating whether or not to include a reference line.}

\item{refline.col}{The color to use for the reference line. Default is
\code{2}.}

\item{refline.fill}{The color to use for filling in the polygon-shaped 
reference line. Default is \code{2}.}

\item{refline.lty}{The type of line to use for the reference line. Default is
\code{"dashed"}.}

\item{refline.lwd}{The width of the reference line. Default is \code{1}.}

\item{...}{Additional optional argument to be passed on to other methods.}
}
\value{
A \code{"lift"} object, which is essentially a list with the
following components:
\describe{

  \item{\code{"lift"}}{A numeric vector containing the computed lift values.}

  \item{\code{"prop"}}{The corresponding proportion of cases associated with
  each lift value.}

  \item{\code{"cumulative"}}{Same value as that supplied via the
  \code{cumulative} argument. (Used by the \code{plot.lift()} method.)}

}
}
\description{
Validates predicted probabilities against a set of observed (binary)
outcomes.
}
