% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrm.R
\name{rrm}
\alias{rrm}
\title{Random rotation matrix}
\source{
https://www.jmlr.org/papers/volume17/blaser16a/blaser16a.pdf.
}
\usage{
rrm(n)
}
\arguments{
\item{n}{Integer specifying the dimension of the resulting (square) random 
rotation matrix.}
}
\value{
An \code{n}-by-\code{n} matrix (i.e., an object of class 
\code{c("matrix" "array")}.
}
\description{
Generates a random rotation matrix as described in Blaser and Fryzlewicz 
(2016).
}
\examples{
(R <- rrm(3))
det(R)  # determinant should always be +1
solve(R)  # R^{-1} = R'
t(R)  # R^{-1} = R'
}
\references{
Rico Blaser and Piotr Fryzlewicz. Random rotation ensembles. Journal of 
Machine Learning Research, 17:1–26, 2016.
}
