% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeToPoly.R
\name{treeToPoly}
\alias{treeToPoly}
\title{Convert trees to coefficient matrices}
\usage{
treeToPoly(trees, type = "real", numThreads = -1)
}
\arguments{
\item{trees}{a single phylo object or a list of phylo objects}

\item{type}{one of:
\describe{
  \item{\dQuote{real}}{real coefficient polynomials}
  \item{\dQuote{complex}}{complex coefficient polynomials (real polynomials with y = 1 + i)}
  \item{\dQuote{tipLabel}}{complex coefficient polynomial that utilize binary trait tip labels on the phylo objects}
}}

\item{numThreads}{number of threads to be used, the default (-1) will use the number of cores in the machine and numThreads = 0 will only use the main thread}
}
\value{
the resulting coefficient matrix or matrices of the form:
\describe{
  \item{\dQuote{real}}{a real matrix where the ith row, jth column represents the x^(j-1)*y^(i-1) coefficient}
  \item{\dQuote{complex}}{a complex vector where the kth column represents the x^(k-1) coefficient}
  \item{\dQuote{tipLabel}}{given trees with two unique tip labels \dQuote{a}, \dQuote{b} a complex matrix where the ith row, jth column represents the a^(i-1)*b^(j-1) coefficient}
}
}
\description{
Converts rooted full binary trees to tree distinguishing polynomials described with coefficient matrices.
}
\examples{
library(treenomial)
library(ape)

# generate a tree
tree <- rtree(n = 30, rooted = TRUE)

# a real coefficient matrix
treeToPoly(tree, numThreads = 0)

# complex coefficient vector for the tree
treeToPoly(tree, type = "complex", numThreads = 0)

# for a list of trees
treeToPoly(rmtree(10, 30), numThreads = 0)

}
