% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_reference_dataset.R
\name{set_reference_dataset}
\alias{set_reference_dataset}
\title{Set reference dataset}
\usage{
set_reference_dataset(unified_model, x)
}
\arguments{
\item{unified_model}{Unified model representation of the model created with a (model).unify function. (\code{\link{model_unified.object}}).}

\item{x}{Reference dataset. A \code{data.frame} or \code{matrix} with the same columns as in the training set of the model.}
}
\value{
\code{\link{model_unified.object}}. Unified representation of the model as created with a (model).unify function,
but with changed reference dataset (Cover column containing updated values).
}
\description{
Change a dataset used as reference for calculating SHAP values.
Reference dataset is initially set with \code{data} argument in unifying function.
Usually reference dataset is dataset used to train the model.
Important property of reference dataset is that SHAP values for each observation add up to its deviation from mean prediction for a reference dataset.
}
\examples{
\donttest{
library(gbm)
data <- fifa20$data[colnames(fifa20$data) != 'work_rate']
data['value_eur'] <- fifa20$target
gbm_model <- gbm::gbm(
formula = value_eur ~ .,
  data = data,
  distribution = "laplace",
  n.trees = 20,
  interaction.depth = 4,
  n.cores = 1)
unified <- gbm.unify(gbm_model, data)
set_reference_dataset(unified, data[200:700, ])
}
}
\seealso{
\code{\link{lightgbm.unify}} for \code{\link[lightgbm:lightgbm]{LightGBM models}}

\code{\link{gbm.unify}} for \code{\link[gbm:gbm]{GBM models}}

\code{\link{xgboost.unify}} for \code{\link[xgboost:xgboost]{XGBoost models}}

\code{\link{ranger.unify}} for \code{\link[ranger:ranger]{ranger models}}

\code{\link{randomForest.unify}} for \code{\link[randomForest:randomForest]{randomForest models}}
}
