% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unify_xgboost.R
\name{xgboost.unify}
\alias{xgboost.unify}
\title{Unify XGBoost model}
\usage{
xgboost.unify(xgb_model, data, recalculate = FALSE)
}
\arguments{
\item{xgb_model}{A XGBoost model - object of class \code{xgb.Booster}}

\item{data}{Reference dataset. A \code{data.frame} or \code{matrix} with the same columns as in the training set of the model. Usually dataset used to train model.}

\item{recalculate}{logical indicating if covers should be recalculated according to the dataset given in data. Keep it \code{FALSE} if training data are used.}
}
\value{
a unified model representation - a \code{\link{model_unified.object}} object
}
\description{
Convert your XGBoost model into a standardized representation.
The returned representation is easy to be interpreted by the user and ready to be used as an argument in \code{treeshap()} function.
}
\examples{
\donttest{
library(xgboost)
data <- fifa20$data[colnames(fifa20$data) != 'work_rate']
target <- fifa20$target
param <- list(objective = "reg:squarederror", max_depth = 3)
xgb_model <- xgboost::xgboost(as.matrix(data), params = param, label = target,
                              nrounds = 20, verbose = 0)
unified_model <- xgboost.unify(xgb_model, as.matrix(data))
shaps <- treeshap(unified_model, data[1:2,])
plot_contribution(shaps, obs = 1)
}

}
\seealso{
\code{\link{lightgbm.unify}} for \code{\link[lightgbm:lightgbm]{LightGBM models}}

\code{\link{gbm.unify}} for \code{\link[gbm:gbm]{GBM models}}

\code{\link{ranger.unify}} for \code{\link[ranger:ranger]{ranger models}}

\code{\link{randomForest.unify}} for \code{\link[randomForest:randomForest]{randomForest models}}
}
