% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_leaf_depth.R
\name{average_leaf_depth}
\alias{average_leaf_depth}
\title{Calculate the average leaf depth statistic. The average leaf depth statistic
is a normalized version of the Sackin index, normalized by the number of
tips.}
\usage{
average_leaf_depth(phy, normalization = "none")
}
\arguments{
\item{phy}{phylo object or ltable}

\item{normalization}{"none" or "yule", in which case the statistic is
divided by the expectation under the yule model, following Remark 1 in
Coronado et al. 2020.}
}
\value{
average leaf depth statistic
}
\description{
Calculate the average leaf depth statistic. The average leaf depth statistic
is a normalized version of the Sackin index, normalized by the number of
tips.
}
\examples{
simulated_tree <- ape::rphylo(n = 10, birth = 1, death = 0)
average_leaf_depth(simulated_tree)
}
\references{
M. Coronado, T., Mir, A., Rosselló, F. et al. On Sackin’s
original proposal: the variance of the leaves’ depths as a phylogenetic
balance index. BMC Bioinformatics 21, 154 (2020).
https://doi.org/10.1186/s12859-020-3405-1
K.-T. Shao and R. R. Sokal. Tree balance. Systematic Zoology,
39(3):266, 1990. doi: 10.2307/2992186.
}
